/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonObject;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.entity.ChairEntity;
import com.yuushya.item.FormTransItem;
import com.yuushya.item.SetHatItem;
import com.yuushya.item.TemplateBlockItem;
import com.yuushya.item.TemplateChildBlockItem;
import com.yuushya.item.YuushyaItemFactory;
import com.yuushya.particle.YuushyaParticleBlock;
import com.yuushya.registries.YuushyaCreativeModeTab;
import com.yuushya.registries.YuushyaDeferredRegister;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaUtils;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class YuushyaRegistries {
    public static final YuushyaDeferredRegister<Block> BLOCKS = new YuushyaDeferredRegister(Registry.f_122901_);
    public static final YuushyaDeferredRegister<Item> ITEMS = new YuushyaDeferredRegister(Registry.f_122904_);
    public static final YuushyaDeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = new YuushyaDeferredRegister(Registry.f_122907_);
    public static final YuushyaDeferredRegister<EntityType<?>> ENTITIES = new YuushyaDeferredRegister(Registry.f_122903_);
    public static final YuushyaDeferredRegister<ParticleType<?>> PARTICLE_TYPES = new YuushyaDeferredRegister(Registry.f_122906_);
    public static final Map<String, YuushyaRegistryData.Block> BlockALL = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockTemplate = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockOnly = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockRemain = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> TextureTypeMap = new HashMap<String, YuushyaRegistryData.Block>();
    public static final List<Runnable> RegisterList = new ArrayList<Runnable>();
    public static RegistrySupplier<EntityType<?>> CHAIR_ENTITY = null;

    public static void registerRegistries() {
        for (YuushyaRegistryData.Item item : YuushyaRegistryConfig.YuushyaRawItemMap.values()) {
            RegisterList.add(() -> ITEMS.register(item.name, () -> YuushyaItemFactory.create(item)));
        }
        block12: for (YuushyaRegistryData.Block block : YuushyaRegistryConfig.YuushyaRawBlockMap.values()) {
            switch (block.classType) {
                case "_comment": 
                case "class": {
                    continue block12;
                }
                case "remain": {
                    BlockRemain.put(block.name, block);
                    continue block12;
                }
                case "template": {
                    RegisterList.add(() -> ITEMS.register(block.name, () -> new TemplateBlockItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(block.itemGroup)), 1, block.name)));
                    BlockTemplate.put(block.name, block);
                    continue block12;
                }
            }
            BlockALL.put(block.name, block);
            RegisterList.add(() -> BLOCKS.register(block.name, () -> YuushyaBlockFactory.create(block)));
            RegisterList.add(() -> ITEMS.register(block.name, () -> new BlockItem((Block)BLOCKS.get(block.name).get(), new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(block.itemGroup)))));
            if (block.texture == null || block.texture.type == null || block.texture.type.isEmpty()) continue;
            TextureTypeMap.put(block.name, block);
        }
        for (YuushyaRegistryData.Block blockRemain : BlockRemain.values()) {
            ResourceLocation blockResourceLocation = new ResourceLocation(blockRemain.name);
            if (blockRemain.texture == null) {
                blockRemain.texture = new YuushyaRegistryData.Block.Texture();
                blockRemain.texture.type = "all";
            }
            if (blockRemain.texture.value == null || blockRemain.texture.value.isEmpty()) {
                blockRemain.texture.value = new ResourceLocation(blockResourceLocation.m_135827_(), "block/" + blockResourceLocation.m_135815_()).toString();
            }
            if (blockRemain.texture.type == null || blockRemain.texture.type.isEmpty()) continue;
            TextureTypeMap.put(blockRemain.name, blockRemain);
        }
        for (YuushyaRegistryData.Block block : BlockOnly.values()) {
            if (block.renderType == null || block.renderType.isEmpty()) {
                block.renderType = "cutout";
            }
            if (block.itemGroup == null) {
                block.itemGroup = "yuushya_extrablocks";
            }
            RegisterList.add(() -> BLOCKS.register(block.name, () -> new YuushyaBlockFactory.BlockWithClassType(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_), 1, "block", "block", null)));
            RegisterList.add(() -> ITEMS.register(block.name, () -> new BlockItem((Block)BLOCKS.get(block.name).get(), new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(block.itemGroup)))));
            if (block.texture == null) {
                block.texture = new YuushyaRegistryData.Block.Texture();
                block.texture.type = "all";
            }
            if (block.texture.type != null && !block.texture.type.isEmpty()) {
                TextureTypeMap.put(block.name, block);
            }
            BlockALL.put(block.name, block);
        }
        for (YuushyaRegistryData.Block templateBlock : BlockTemplate.values()) {
            JsonObject templateBlockJson = GsonTools.NormalGSON.toJsonTree((Object)templateBlock, YuushyaRegistryData.Block.class).getAsJsonObject();
            List<YuushyaRegistryData.Block> list = YuushyaRegistries.getTemplateUsageList(templateBlock);
            for (YuushyaRegistryData.Block block : list) {
                String name;
                BlockBehaviour.Properties properties;
                JsonObject blockJson = GsonTools.NormalGSON.toJsonTree((Object)block, YuushyaRegistryData.Block.class).getAsJsonObject();
                YuushyaRegistryData.Block blockNew = GsonTools.combineYuushyaDataBlockJson(blockJson, templateBlockJson);
                blockNew.properties.parent = block.name;
                if (block.classType.equals("remain")) {
                    ResourceLocation blockResourceLocation = new ResourceLocation(block.name);
                    properties = YuushyaBlockFactory.getBlockProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)Registry.f_122824_.m_7745_(blockResourceLocation))), blockNew.properties);
                    if (blockNew.properties != null) {
                        properties.m_155949_(YuushyaUtils.toMaterialColor(blockNew.properties.material));
                    } else {
                        properties.m_155949_(MaterialColor.f_76398_);
                    }
                    name = blockResourceLocation.m_135815_();
                } else {
                    properties = YuushyaBlockFactory.getBlockProperties(blockNew.properties);
                    name = block.name;
                }
                blockNew.name = templateBlock.name + "_" + name;
                blockNew.classType = "template:" + templateBlock.name;
                RegisterList.add(() -> BLOCKS.register(blockNew.name, () -> YuushyaBlockFactory.create(properties, blockNew)));
                RegisterList.add(() -> ITEMS.register(blockNew.name, () -> new TemplateChildBlockItem((Block)BLOCKS.get(blockNew.name).get(), new Item.Properties(), block.classType, templateBlock.name, block.name)));
                BlockALL.put(blockNew.name, blockNew);
            }
        }
        for (YuushyaRegistryData.Particle particle : YuushyaRegistryConfig.YuushyaRawParticleMap.values()) {
            if (particle.spawner == null) {
                particle.spawner = new YuushyaRegistryData.Block();
            }
            if (particle.spawner.properties == null) {
                particle.spawner.properties = new YuushyaRegistryData.Block.Properties();
            }
            if (particle.spawner.name == null || particle.spawner.name.isEmpty()) {
                particle.spawner.name = particle.name + "_spawner";
            }
            RegisterList.add(() -> BLOCKS.register(particle.spawner.name, () -> new YuushyaParticleBlock(YuushyaBlockFactory.getBlockProperties(particle.spawner.properties), particle.spawner.properties.lines, "ParticleBlock", "block", particle.spawner.usage, () -> (SimpleParticleType)PARTICLE_TYPES.get(particle.name).get())));
            RegisterList.add(() -> ITEMS.register(particle.spawner.name, () -> new BlockItem((Block)BLOCKS.get(particle.spawner.name).get(), new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(particle.spawner.itemGroup)))));
            RegisterList.add(() -> PARTICLE_TYPES.register(particle.name, YuushyaParticleBlock.YuushyaParticleType::create));
        }
    }

    public static List<YuushyaRegistryData.Block> getTemplateUsageList(YuushyaRegistryData.Block templateBlock) {
        ArrayList<YuushyaRegistryData.Block> list = new ArrayList<YuushyaRegistryData.Block>();
        if (templateBlock.texture == null || templateBlock.texture.forClass == null && templateBlock.texture.forSpecified == null) {
            list.addAll(TextureTypeMap.values());
        } else {
            if (templateBlock.texture.forClass != null) {
                list.addAll(TextureTypeMap.values().stream().filter(e -> templateBlock.texture.forClass.contains(e.texture.type)).toList());
            }
            if (templateBlock.texture.forSpecified != null) {
                templateBlock.texture.forSpecified.forEach(name -> {
                    ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)name);
                    if (resourceLocation != null) {
                        if (TextureTypeMap.containsKey(resourceLocation.toString())) {
                            list.add(TextureTypeMap.get(resourceLocation.toString()));
                        }
                        if (TextureTypeMap.containsKey(resourceLocation.m_135815_())) {
                            list.add(TextureTypeMap.get(resourceLocation.m_135815_()));
                        }
                    }
                });
            }
        }
        return list;
    }

    public static void registerAll() {
        RegisterList.forEach(Runnable::run);
        RegisterList.clear();
        ITEMS.register("form_trans_item", () -> new FormTransItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.YUUSHYA_ITEM).m_41487_(1), 2));
        ITEMS.register("pilatory", () -> new SetHatItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.YUUSHYA_ITEM).m_41487_(64), 2));
        CHAIR_ENTITY = ENTITIES.register("ride_entity", () -> EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.02f).m_20712_("ride_entity"));
    }

    public static void registerClient() {
        BlockALL.values().forEach(block -> {
            RenderTypeRegistry.register((RenderType)YuushyaUtils.toRenderType(block.renderType), (Block[])new Block[]{(Block)BLOCKS.get(block.name).get()});
            if (block.colorTint != null && block.colorTint.colorType != null && !block.colorTint.colorType.isEmpty() && !block.colorTint.colorType.equals("null")) {
                ColorHandlerRegistry.registerBlockColors((BlockColor)YuushyaUtils.toBlockColor(block.colorTint.colorType, block.colorTint.colorString), (Supplier[])new Supplier[]{BLOCKS.get(block.name)});
            }
        });
    }
}

